import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.IOException;
import java.util.StringTokenizer;

public class CardGame {

    private static final int MAXN = 200005;

    // ???????? ?????????? ?? ????????? ?????
    private static int N;
    private static int Q;
    private static int[] A = new int[MAXN]; // ??? ??????
    private static int[] C = new int[MAXN]; // ???? ??????????? C[v]
    private static long totalSumOdd = 0; // ???? R_O (?????? ???? ?????? ???? ??????????)
    private static int totalPairs = 0; // ?????? ???? ?????? S

    // Segment Tree ?????????: ???? count ? sum ?????? ?? ??????????? v
    private static long[] treeCount = new long[4 * MAXN]; // ???? ?????? (PairCount[v])
    private static long[] treeSum = new long[4 * MAXN];   // ???? v * PairCount[v]

    // --- Segment Tree ?????? ---

    /**
     * ??????? Segment Tree ???? ?? PairCount[v] ???????.
     * @param node ???????? ????
     * @param L ??????? ??????
     * @param R ???? ??????
     * @param index ???????? v ???? PairCount ??????
     * @param newPairCount ???? ???????? PairCount[v]
     */
    private static void updateTree(int node, int L, int R, int index, int newPairCount) {
        if (L == R) {
            // Index = ???????? v
            treeCount[node] = newPairCount;
            treeSum[node] = (long) newPairCount * index;
            return;
        }

        int mid = L + (R - L) / 2;
        if (index <= mid) {
            updateTree(2 * node, L, mid, index, newPairCount);
        } else {
            updateTree(2 * node + 1, mid + 1, R, index, newPairCount);
        }

        // ????????? ????????
        treeCount[node] = treeCount[2 * node] + treeCount[2 * node + 1];
        treeSum[node] = treeSum[2 * node] + treeSum[2 * node + 1];
    }

    /**
     * ?????????? ???? ????????? K ???????? ??????.
     * ??? ?? ???? ?? K-?? ??????? ??????? (?? ????????? v).
     * @param node ???????? ????
     * @param L ??????? ??????
     * @param R ???? ??????
     * @param K ???? ???????? ?????? ???? ??????? (NumNonPlayedPairs)
     * @return ???? ????????? v * PairCount[v] ?? K ???????? ??????.
     */
    private static long querySmallestPairsSum(int node, int L, int R, long K) {
        if (K <= 0) {
            return 0;
        }

        // ??? ?? K ???? ??? ??????? ????? ???? ?????? ? ???? ???-??????, ????? ???? ????
        if (treeCount[node] <= K) {
            return treeSum[node];
        }

        // ??? ??? ????? ?? ?????
        if (L == R) {
            // ??? ???????? v ?? K-?? ???????. ??????? K ?????? ??? ?????????.
            return K * L;
        }

        int mid = L + (R - L) / 2;
        
        // ?????? ? ????? ???-??????
        if (treeCount[2 * node] >= K) {
            // K-?? ??????? ?? ? ????? ????
            return querySmallestPairsSum(2 * node, L, mid, K);
        } else {
            // ??????? ??? ?????? ?? ????? ???? + ??????? ?? ??????
            long result = treeSum[2 * node];
            result += querySmallestPairsSum(2 * node + 1, mid + 1, R, K - treeCount[2 * node]);
            return result;
        }
    }


    // --- ?????? ????? ---

    /**
     * ?????? ????? ???? 2: ??????? A[x] := Y.
     * ??????? C[v], TotalSumOdd, TotalPairs ? Segment Tree.
     */
    private static void type2Query(int X, int Y) {
        int vOld = A[X];
        int vNew = Y;

        if (vOld == vNew) return;

        // 1. ???????? ?????? (vOld)
        
        // ??????? ???????? ??? ???????
        if (C[vOld] % 2 != 0) { // C[vOld] ?? ???????
            totalSumOdd -= vOld;
        }

        // ????????? S ? Tree (PairCount[v])
        int oldPairCount = C[vOld] / 2;
        totalPairs -= oldPairCount;
        C[vOld]--;
        int newPairCount = C[vOld] / 2;
        totalPairs += newPairCount;

        if (oldPairCount != newPairCount) {
            updateTree(1, 1, N, vOld, newPairCount);
        }

        // ??????? ???????? ????? ???????
        if (C[vOld] % 2 != 0) { // C[vOld] ?? ???????
            totalSumOdd += vOld;
        }


        // 2. ???????? ????? (vNew)

        // ??????? ???????? ??? ???????
        if (C[vNew] % 2 != 0) { // C[vNew] ?? ???????
            totalSumOdd -= vNew;
        }

        // ????????? S ? Tree
        oldPairCount = C[vNew] / 2;
        totalPairs -= oldPairCount;
        C[vNew]++;
        newPairCount = C[vNew] / 2;
        totalPairs += newPairCount;

        if (oldPairCount != newPairCount) {
            updateTree(1, 1, N, vNew, newPairCount);
        }

        // ??????? ???????? ????? ???????
        if (C[vNew] % 2 != 0) { // C[vNew] ?? ???????
            totalSumOdd += vNew;
        }

        // ????????? A ????
        A[X] = Y;
    }

    /**
     * ?????? ????? ???? 1: ???? ??????? ?????? ???? ?????? ?? K.
     */
    private static long type1Query(int K) {
        // P: ???? ?????? ???? ?????? ?? ????????
        int P = N - K;
        // S: ?????? ???? ?????? ???? ????? ????????
        int S = totalPairs;

        if (P >= S) {
            // ????? ??????? ?????? ?? ???????? ??? ??????.
            // ?????? ???? TotalSumOdd (R_O).
            return totalSumOdd;
        } else {
            // ?????? ??????? ??????. S - P ?????? ???? ???? ????????.
            long numNonPlayedPairs = S - P; // ???? ?????? ???? ??????
            
            // RP: ???? ????????? ???????? numNonPlayedPairs ?????? (v * PairCount[v]).
            long RP = querySmallestPairsSum(1, 1, N, numNonPlayedPairs);

            // ?????? ???? = R_O + 2 * RP (??? RP ?????????? ???? ????????? v, ? ?? 2*v)
            return totalSumOdd + 2 * RP;
        }
    }

    // --- ?????? ???????? ? ??????????????? ---

    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter pw = new PrintWriter(System.out);
        StringTokenizer st;

        st = new StringTokenizer(br.readLine());
        N = Integer.parseInt(st.nextToken());
        Q = Integer.parseInt(st.nextToken());

        // ?????? ? ???????????????
        st = new StringTokenizer(br.readLine());
        for (int i = 1; i <= N; i++) {
            A[i] = Integer.parseInt(st.nextToken());
            
            // ????? ????????? (???? ??? Type2Query)
            int v = A[i];
            
            if (C[v] % 2 != 0) totalSumOdd -= v;
            
            int oldPairCount = C[v] / 2;
            totalPairs -= oldPairCount;
            C[v]++;
            int newPairCount = C[v] / 2;
            totalPairs += newPairCount;

            if (oldPairCount != newPairCount) {
                updateTree(1, 1, N, v, newPairCount);
            }

            if (C[v] % 2 != 0) totalSumOdd += v;
        }

        // ?????? ?????
        for (int i = 0; i < Q; i++) {
            st = new StringTokenizer(br.readLine());
            int type = Integer.parseInt(st.nextToken());

            if (type == 1) {
                int X = Integer.parseInt(st.nextToken());
                pw.println(type1Query(X));
            } else {
                int X = Integer.parseInt(st.nextToken());
                int Y = Integer.parseInt(st.nextToken());
                type2Query(X, Y);
            }
        }

        pw.flush();
        pw.close();
        br.close();
    }
}